#pragma rtGlobals=1		// Use modern global access method.

menu "Plot&Fit"
"-"
	Submenu "Major Tools"
		"SAS Modeling Tool/5", SAS_Panel()
		"SA from UNICAT Unified fit/7",SurfaceArea()//1,1,1,5,6)//(level,anal,densSam, mtl,solv)
	end

	Submenu "Surface Area Utilities"
		"Surface area Calculations",SAcalcs(100,1,1.2,2,100)
		"Surface area from NIST SAS Distribution",SAfromDist()
		"Density from Bx and Bn",DensityfromBxandBn()
	end
end

function DensityfromBxandBn(Bn,Bx,wtpctn, wtpctx)//depends on compostions in SAS modeling tool. matches neutron and xray by changing skldens
	variable Bn,Bx,wtpctx,wtpctn
	variable nSL,xSL,xSL2, nSL2, xSLD2, nSLD2,a,b,c,rho,phix,phin,Bxnew
	wave composition=Root:packages:P:composition
	wave composition2=Root:packages:P:composition2
	variable matrixdens=composition2[0]
	variable skldens	
	do
		skldens=composition[0]	
		phix = (wtpctx/skldens)/((wtpctx/skldens)+(100-wtpctx)/matrixdens)
		phin = (wtpctn/skldens)/((wtpctn/skldens)+(100-wtpctn)/matrixdens)
	
		Bxnew=Bx*phin*(1-phin)/(phix*(1-phix))
		xSL=scattlength11(composition,1)
		nSL=scattlength11(composition,2)
		xSL2=scattlength11(composition2,1)
		nSL2=scattlength11(composition2,2)
		xSLD2=composition2[0]*xSL2
		nSLD2=composition2[0]*nSL2
	
		a=((Bn/Bxnew)*xSL^2)-nSL^2
		b=2*(nSL*nSLD2-xSL*xSLD2*(Bn/Bxnew))
		c=((Bn/Bxnew)*xSLD2^2)-nSLD2^2
		rho=((-b)+sqrt(b^2-4*a*c))/(2*a)//need to pick next equation sometimes
		//rho=((-b)-sqrt(b^2-4*a*c))/(2*a)
		//	print rho
		composition[0]=rho
	while ((abs((rho-skldens)/rho))>.00001)	
	DWS_PnlSetVarProc("density",1,"","")//resets phi in SAS modeling tool
	
end



Function DWS_PnlSetVarProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName	
	NVAR SL=Root:packages:P:SL
		NVAR SL2=Root:packages:P:SL2
		NVAR SLD=Root:packages:P:SLD
		NVAR SLD2=Root:packages:P:SLD2
		NVAR Drhosq=Root:packages:P:Drhosq
		NVAR Drho=Root:packages:P:Drho
	if ((cmpstr("radius",ctrlName)==0)||(cmpstr("length",ctrlName)==0)||(cmpstr("phi",ctrlName)==0)||(cmpstr("Thickness",ctrlName)==0))//||(cmpstr("Rinner",ctrlname)==0))
		DWS_ButtonProc("CalculateUnified")
	endif
		if ((cmpstr("D",ctrlName)==0)||(cmpstr("persist",ctrlName)==0)||(cmpstr("Rcluster",ctrlName)==0))
		DWS_ButtonProc("CalculateUnified")
	endif
	If ((cmpstr("SLD",ctrlname)==0)||(cmpstr("SLD2",ctrlName)==0))
		Drhosq=(SLD2-SLD)^2//cm-4
		Drho=(SLD2-SLD)*1e-16//A^-2
	endif
	
	If (cmpstr("Drhosq",ctrlname)==0)
		NVAR Drhosq=Root:packages:P:Drhosq
		NVAR Drho=Root:packages:P:Drho
		Drho = sqrt(Drhosq)*1e-16
	endif	
	If (cmpstr("Drho",ctrlname)==0)
		NVAR Drhosq=Root:packages:P:Drhosq
		NVAR Drho=Root:packages:P:Drho	
		Drhosq = (Drho*1e16)^2
	endif
	
	If ((cmpstr("Density",ctrlname)==0)||(cmpstr("wtpct",ctrlname)==0)||(cmpstr("Density2",ctrlname)==0))
		NVAR phi=Root:packages:P:phi
		NVAR wtpct=Root:packages:P:wtpct
		NVAR samdensity=Root:packages:P:samdensity
		NVAR mixSLD=Root:packages:P:MixSLD
		wave composition=Root:packages:P:composition
		wave composition2=Root:packages:P:composition2
		variable matrixdens=composition2[0]
		variable skldens=composition[0]	
		phi = (wtpct/skldens)/((wtpct/skldens)+(100-wtpct)/matrixdens)
		
		samdensity=phi*skldens+(1-phi)*matrixdens
		DWS_ButtonProc("calculateSLD")
		MixSLD=1e-10*(phi*SLD+(1-phi)*SLD2)
	endif
end

Function DisplayScattlength()
	setdatafolder root:Packages:P
	wave Elements,xSLs,nSLs,AW, Composition,Composition2//,AW1,delrw,elementspresent
	Edit/K=1 Elements,xSLs,nSLs,AW, Composition,Composition2//,AW1,delrw,elementspresent
end

function Reset_SLs()
	setdatafolder root:packages:P
	Make/o/n=20 Composition=0;Make/o/n=20 Composition2=0
	Make/o/n=20 xSLs=0;Make/o/n=20 nSLs=0;Make/o/n=20 AW=1
	make/o/n=20/T Elements
	elements[0,13]=		{"Density","C","H","O","S","Si","Cl","N","Ti","D","Al","Fe","Cr","open"}     
	AW[0,18]={0,      12,   1,    16,     32,    28,   35.5,  14,    48,      2,    27,  55.85,51.99,0,0,0,0,0,0}
	xSLs[0,18]= {0,1.69,0.282,2.26,4.51,3.94,4.79,7*.282,6.204,.282, 3.64,7.33,6.768,0,0,0,0,0,0}
	xSLs*=1e-12 
	nSLs[0,19]= {0,.665,-.374,0.58,.28,0.42,0.96,0.94,-.384,0.667, 0.345,.9542,.3635,0,0,0,0,0,0,0 }
	nSLs*=1e-12	
	string/g Compounds
	svar compounds
	Compounds ="Compounds;Capture;EPOXY;SWNT"
	make/o/n=(20,10) cmpdmatrix
end

function ScattLength11(composition,type)
	wave composition//atomic composition n=20, composition[0]= is density
	variable type//xray =1 neutron =2
	variable SL
	string DF=getdatafolder(1)
		setdatafolder root:Packages:P
	duplicate/o composition,SLs,AWtemp
	wave AW//atomic weight
	wave xSLs=Root:packages:P:xSLs//X-ray
	wave nSLs=Root:packages:P:nSLs//Neutron
	if( exists("xSLs")!=1	)
		rename xSLDs, xSLs
		rename nSLDs, nSLs	
		wave xSLs=Root:packages:P:xSLs//X-ray
		wave nSLs=Root:packages:P:nSLs//Neutron
	endif
	if (type==1)//x-ray
			SLs=6.02e23* Composition*xSLs//xray atomic SLs
	else
			SLs=6.02e23*Composition*nSLs//Neutron  SLs
	endif 
	AWtemp=AW*composition
	SL=sum(SLs)/sum(AWtemp)
	//Print "The scattering length (SL) = "+num2str(delr)+" cm/g"
	killwaves SLs,AWtemp
	setdatafolder DF
	return SL
end

function CalcSLD(density,composition)//Scattering Length Density in cm-2
	variable density
	wave composition
	variable b,delta,rho
	NVAR type=Root:packages:P:type
	b=ScattLength11(composition,type)
	rho=density*b
	//if(!composition[1]==1)
	//	doalert 0,"delta assumes lambda = 1.54 A"
	//endif
	//delta=(rho/2/pi)*(1.54e-8)^2
	print "Scattering length density (rho) = "+num2str(rho)+" cm^-2"
	//print "Refractive index increment for 1.54 A (delta) = "+num2str(delta)
end

Window SAS_Panel() : Panel
	//IR1A_UnifiedModel()
	PauseUpdate; Silent 1		// building window...
	DoWindow/K DWS_SLD_Panel
	NewPanel/K=1/W=(2.25,43.25,390,790)
	dowindow/C DWS_SLD_Panel
	SetDrawLayer UserBack
	SetDrawEnv fname= "Times New Roman",fsize= 22,fstyle= 3,textrgb= (0,0,52224)
	variable position=8,ypos=80
	DrawText 100,28,"SAS Modeling Tool"
	SetDrawEnv fsize= 16,fstyle= 1	
	DrawText 18,50,"Phase 1"
	SetDrawEnv fsize= 16,fstyle= 1
	DrawText 160,50,"Phase 2"
	SetDrawEnv linethick= 3,linefgc= (0,0,52224)//blue
	DrawLine 16,25,ypos+250,25
	SetDrawEnv fsize= 16,fstyle= 1
	setdatafolder root:packages:P
	if(!waveexists(Root:packages:P:Composition))
		Reset_SLs()
	endif

	variable/g Root:packages:P:SL,Root:packages:P:SL2,Root:packages:P:SLD,Root:packages:P:SLD2,Root:packages:P:Type,Root:packages:P:Drhosq,Root:packages:P:Drho,Root:packages:P:Morphology,Root:packages:P:Radius,Root:packages:P:Thickness//, Root:packages:P:rinner
	variable/g Root:packages:P:phi, Root:packages:P:Length,Root:packages:P:qmin=1e-4,Root:packages:P:qmax=0.2, Root:packages:P:wtpct,Root:packages:P:D,Root:packages:P:persist,Root:packages:P:Rcluster
	variable/g 	Root:packages:P:samdensity,Root:packages:P:MixSLD
	string/g ,Root:packages:P:tagit
	string oldDf=GetDataFolder(1)

	if (!DataFolderExists("root:Packages:SASDataModification"))		//create folder
		NewDataFolder/O root:Packages
		NewDataFolder/O/S root:Packages:SASDataModification
		string/g,NewQwaveName="qtest",newdatafoldername,NewIntensityWaveName="rtest",NewErrorWaveName="stest"
	endif
	
	if (!DataFolderExists("root:Packages:SASModeling"))		//create folder
		NewDataFolder/O root:Packages
		NewDataFolder/O/S root:Packages:SAS_Modeling	
		variable/g,SASBackground
	endif
	setdatafolder root:
	SetVariable Density,pos={Position,60},size={90,16},proc=DWS_PnlSetVarProc,title="rho   "
	SetVariable Density,limits={0,inf,0.1},value= Root:packages:P:composition[0]//g/cm3
	SetVariable Carbon,pos={Position,Ypos},size={90,16},proc=DWS_PnlSetVarProc,title="C   "
	SetVariable Carbon,limits={0,inf,1},value= Root:packages:P:Composition[1]
	SetVariable Hydrogen,pos={Position,Ypos+20},size={90,16},proc=DWS_PnlSetVarProc,title="H   "
	SetVariable Hydrogen,limits={0,inf,1},value= Root:packages:P:Composition[2]	
	SetVariable Oxygen,pos={Position,Ypos+40},size={90,16},proc=DWS_PnlSetVarProc,title="O   "
	SetVariable Oxygen,limits={0,inf,1},value= Root:packages:P:Composition[3]	
	SetVariable Sulfur,pos={Position,Ypos+60},size={90,16},proc=DWS_PnlSetVarProc,title="S   "
	SetVariable Sulfur,limits={0,inf,1},value= Root:packages:P:Composition[4]
	SetVariable Silicon,pos={Position,Ypos+80},size={90,16},proc=DWS_PnlSetVarProc,title="Si  "
	SetVariable Silicon,limits={0,inf,1},value= Root:packages:P:Composition[5]	
	SetVariable Chlorine,pos={Position,Ypos+100},size={90,16},proc=DWS_PnlSetVarProc,title="Cl  "
	SetVariable Chlorine,limits={0,inf,1},value= Root:packages:P:Composition[6]	
	SetVariable Nitrogen,pos={Position,Ypos+120},size={90,16},proc=DWS_PnlSetVarProc,title="N   "
	SetVariable Nitrogen,limits={0,inf,1},value= Root:packages:P:Composition[7]	
	SetVariable Titanium,pos={Position,Ypos+140},size={90,16},proc=DWS_PnlSetVarProc,title="Ti  "
	SetVariable Titanium,limits={0,inf,1},value= Root:packages:P:Composition[8]	
	SetVariable Deuterium,pos={Position,Ypos+160},size={90,16},proc=DWS_PnlSetVarProc,title="D   "
	SetVariable Deuterium,limits={0,inf,1},value= Root:packages:P:Composition[9]	
	SetVariable Aluminum,pos={Position,Ypos+180},size={90,16},proc=DWS_PnlSetVarProc,title="Al  "
	SetVariable Aluminum,limits={0,inf,1},value= Root:packages:P:Composition[10]	
	SetVariable Iron,pos={Position,Ypos+200},size={90,16},proc=DWS_PnlSetVarProc,title="Fe   "
	SetVariable Iron,limits={0,inf,1},value= Root:packages:P:Composition[11]
	SetVariable Sodium,pos={Position,Ypos+220},size={90,16},proc=DWS_PnlSetVarProc,title="Cr   "//Changed from Na to Pt in table
	SetVariable Sodium,limits={0,inf,1},value= Root:packages:P:Composition[12]
	
	

	
//	PopupMenu Pick1,pos={position+10,YPOS+230},size={180,21},proc=DWS_SLDPopupControl//,title="Comp"
	//PopupMenu Pick1,mode=1,value=# Root:packages:P:compounds
	//"\"Compounds;EPOXY;SWNT\"
	
	Position = 150;ypos=80
	SetVariable Density2,pos={Position,60},size={90,49},proc=DWS_PnlSetVarProc,title="rho   "
	SetVariable Density2,limits={0,inf,0.1},value= Root:packages:P:composition2[0]
	SetVariable Carbon2,pos={Position,Ypos},size={90,16},proc=DWS_PnlSetVarProc,title="C   "
	SetVariable Carbon2,limits={0,inf,1},value= Root:packages:P:Composition2[1]
	SetVariable Hydrogen2,pos={Position,Ypos+20},size={90,16},proc=DWS_PnlSetVarProc,title="H   "
	SetVariable Hydrogen2,limits={0,inf,1},value= Root:packages:P:Composition2[2]	
	SetVariable Oxygen2,pos={Position,Ypos+40},size={90,16},proc=DWS_PnlSetVarProc,title="O   "
	SetVariable Oxygen2,limits={0,inf,1},value= Root:packages:P:Composition2[3]	
	SetVariable Sulfur2,pos={Position,Ypos+60},size={90,16},proc=DWS_PnlSetVarProc,title="S   "
	SetVariable Sulfur2,limits={0,inf,1},value= Root:packages:P:Composition2[4]
	SetVariable Silicon2,pos={Position,Ypos+80},size={90,16},proc=DWS_PnlSetVarProc,title="Si  "
	SetVariable Silicon2,limits={0,inf,1},value= Root:packages:P:Composition2[5]	
	SetVariable Chlorine2,pos={Position,Ypos+100},size={90,16},proc=DWS_PnlSetVarProc,title="Cl  "
	SetVariable Chlorine2,limits={0,inf,1},value= Root:packages:P:Composition2[6]	
	SetVariable Nitrogen2,pos={Position,Ypos+120},size={90,16},proc=DWS_PnlSetVarProc,title="N   "
	SetVariable Nitrogen2,limits={0,inf,1},value= Root:packages:P:Composition2[7]	
	SetVariable Titanium2,pos={Position,Ypos+140},size={90,16},proc=DWS_PnlSetVarProc,title="Ti  "
	SetVariable Titanium2,limits={0,inf,1},value= Root:packages:P:Composition2[8]	
	SetVariable Deuterium2,pos={Position,Ypos+160},size={90,16},proc=DWS_PnlSetVarProc,title="D   "
	SetVariable Deuterium2,limits={0,inf,1},value= Root:packages:P:Composition2[9]	
	SetVariable Aluminum2,pos={Position,Ypos+180},size={90,16},proc=DWS_PnlSetVarProc,title="Al  "
	SetVariable Aluminum2,limits={0,inf,1},value= Root:packages:P:Composition2[10]	
	SetVariable Iron2,pos={Position,Ypos+200},size={90,16},proc=DWS_PnlSetVarProc,title="Fe   "
	setvariable  Iron2,limits={0,inf,1},value= Root:packages:P:Composition2[11]
	SetVariable Sodium2,pos={Position,Ypos+220},size={90,16},proc=DWS_PnlSetVarProc,title="Cr  "//Changed from Na to Pt in table
	SetVariable Sodium2,limits={0,inf,1},value= Root:packages:P:Composition2[12]

//	PopupMenu Pick2,pos={position+10,YPOS+230},size={180,21},proc=DWS_SLDPopupControl
//	PopupMenu Pick2,mode=1,value=# Root:packages:P:compounds
	//"Compounds;EPOXY;SWNT"
	
	position=8;	Ypos=350	
	SetDrawEnv linethick= 3,linefgc= (0,52224,0)//green line
	DrawLine 16,YPos-5,339,Ypos-5
	
	ValDisplay SL,pos={Position,Ypos},size={110,16},proc=DWS_PnlSetVarProc,title="SL   "
	ValDisplay SL,value= Root:packages:P:SL,format="%.3g"
	
	setvariable SLD,pos={Position,Ypos+20},size={110,16},proc=DWS_PnlSetVarProc,title="SLD"
	setvariable SLd,limits={-Inf,Inf,0},value= Root:packages:P:SLD,format="%.3g"
	position=150
	ValDisplay SL2,pos={Position,Ypos},size={120,16},proc=DWS_PnlSetVarProc,title="SL2   "
	ValDisplay SL2,value= Root:packages:P:SL2,format="%.3g"

	setvariable SLD2,pos={Position,Ypos+20},size={120,16},proc=DWS_PnlSetVarProc,title="SLD2  "
	setvariable SLD2,limits={-Inf,Inf,0},value= Root:packages:P:SLD2,format="%.3g"
	
	setvariable Drhosq,pos={Position-120,Ypos+40},size={160,16},proc=DWS_PnlSetVarProc,title="(Delta rho)^2  "
	setvariable Drhosq,limits={-Inf,Inf,0},value= Root:packages:P:Drhosq,format="%.3g"
	
	Setvariable Drho,pos={Position-120,Ypos+60},size={160,16},proc=DWS_PnlSetVarProc,title="(Delta rho) "
	setvariable Drho,limits={-Inf,Inf,0},value= Root:packages:P:Drho,format="%.3g"
	
	SetDrawEnv fsize= 12,fstyle= 1
	DrawText Position+140,Ypos+35,"cm^-2"
	SetDrawEnv fsize= 12,fstyle= 1
	DrawText Position+140,Ypos+15,"cm/g"
	SetDrawEnv fsize= 12,fstyle= 1
	DrawText Position+90,Ypos+55,"cm^-4"
		SetDrawEnv fsize= 12,fstyle= 1
	DrawText Position+90,Ypos+75,"A^-2"
	
	Position=250;ypos=30
	Button Reset_SL,pos={position,ypos},size={90,20},proc=DWS_ButtonProc,title="Reset_SL"
	PopupMenu Radiation,pos={Position,yPOS+25},size={180,21},proc=DWS_SLDPopupControl
	PopupMenu Radiation,mode=1,popvalue= "x-ray",value= #"\"X-ray;Neutron\""	
	Button CalculateSLD,pos={Position,Ypos+50},size={90,20},proc=DWS_ButtonProc,title="Calculate SLD"	
	Button DisplaySLD,pos={Position,Ypos+100},size={90,20},proc=DWS_ButtonProc,title="Elements"	
	
	CheckBox more pos={Position,Ypos+80},title="Use More elements?", variable=Root:packages:P:moreelements
	CheckBox more proc=DWS_SASPnlCkBox

	
	Position=8;ypos=440
	SetDrawEnv linethick= 3,linefgc= (52224,0,0)//red line
	DrawLine 16,YPos-5,339,Ypos-5
		
	SetVariable qmin,pos={Position,Ypos},size={110,16},proc=DWS_PnlSetVarProc,title="qmin (A)"
	SetVariable qmin,limits={1e-6,.1,1e-5},value= Root:packages:P:qmin
	SetVariable qmax,pos={Position+120,Ypos},size={110,16},proc=DWS_PnlSetVarProc,title="qmax (A)"
	SetVariable qmax,limits={1e-5,10,.1},value= Root:packages:P:qmax	
		YPOS+=15
	
	PopupMenu Morphology,pos={Position,Ypos+5},size={180,21},proc=DWS_SLDPopupControl//,title="Radiation:    "
	PopupMenu Morphology,mode=1,popvalue= "---",value= #"\"Rod;Sphere;Disk;Fractal Rod;Fractal Disk;Fractal Sphere;Tube;Fractal Tube;Hollow Sphere\""	
	SetVariable Radius,pos={Position,Ypos+30},size={130,16},proc=DWS_PnlSetVarProc,title="Hard Radius (A)  "
	SetVariable Radius,limits={0,inf,1},value= Root:packages:P:Radius	

	//SetVariable Rinner,pos={Position+133,Ypos+30},size={120,16},proc=DWS_PnlSetVarProc,title="Rinner (A)  "
	//SetVariable Rinner,limits={0,inf,5},value= Root:packages:P:Rinner
	SetVariable Thickness,pos={Position+133,Ypos+30},size={120,16},proc=DWS_PnlSetVarProc,title="Thickness (A)  "
	SetVariable Thickness,limits={0,inf,1},value= Root:packages:P:Thickness
	SetVariable Length,pos={Position+257,Ypos+30},size={120,16},proc=DWS_PnlSetVarProc,title="Length (A)  "
	SetVariable Length,limits={0,inf,100},value= Root:packages:P:Length	

	
	SetVariable phi,pos={Position+120,Ypos+10},size={100,16},proc=DWS_PnlSetVarProc,title="Phi"
	SetVariable phi,limits={0,1, .001},value= Root:packages:P:phi,format="%.3g"
	
	
	SetVariable Rcluster,pos={Position+230,Ypos+10},size={130,16},proc=DWS_PnlSetVarProc,title="Cluster Size"
	SetVariable Rcluster,limits={0,inf,500},value= Root:packages:P:Rcluster,format="%.3g"
	SetVariable SASbackground,pos={Position+240,Ypos-15},size={110,16},title="Background"
	SetVariable SASbackground,limits={0,inf,0},value= root:Packages:SAS_Modeling:SASBackground,format="%.3g"
	
	setvariable wtpct,pos={10,320},size={90,16},proc=DWS_PnlSetVarProc,title="wtpct"
	setvariable wtpct,limits={0,100,.5},value= Root:packages:P:wtpct,format="%.4g"
	
	SetVariable samdens,pos={120,320},size={100,16},proc=DWS_PnlSetVarProc,title="density"
	SetVariable samdens,limits={0,1,.01},value= Root:packages:P:samdensity,format="%.3g" 
	
	SetVariable mixsld,pos={240,320},size={70,16},title="Mix SLD"
	SetVariable mixsld,limits={0,inf,0},value= Root:packages:P:mixsld,format="%.3g" 
	SetDrawEnv fsize= 9
	DrawText 310,333,"x10^10 "
	
	
	
	SetVariable D,pos={Position,Ypos+50},size={70,16},proc=DWS_PnlSetVarProc,title="D   "
	SetVariable D ,limits={0,3,.1},value= Root:packages:P:D,format="%.3g"	
	SetVariable persist,pos={Position+90,Ypos+50},size={200,16},proc=DWS_PnlSetVarProc,title="persistence Length   "
	SetVariable persist ,limits={0,inf,10},value= Root:packages:P:persist,format="%.3g"
	
	Button CalculateUnified,pos={Position,Ypos+70},size={130,20},proc=DWS_ButtonProc,title="Calculate Unified"	
	Button Plot,pos={Position+150,Ypos+70},size={150,20},proc=DWS_ButtonProc,title="Plot on Top Graph"	
	//Button smear,pos={Position,Ypos+75},size={130,20},proc=DWS_ButtonProc,title="Slit Smear"	
	//Button Plotsmeared,pos={Position+150,Ypos+75},size={150,20},proc=DWS_ButtonProc,title="Plot Smeared"	
	
	YPos+=95
	SetDrawEnv linethick= 3,linefgc= (52224,0,0)//red line
	DrawLine 16,YPos+5,339,Ypos+5
	Ypos=20
	
	PopupMenu SelectFolderNewData,pos={1,Ypos+545},size={250,21},proc=IR1D_PanelPopupControl,title="Save folder", help={"Select folder with data"}
	PopupMenu SelectFolderNewData,mode=1,popvalue="---",value= #"\"---;\"+IR1_GenStringOfFolders(0,1, 0,1)"
	
	SetVariable NewDataFolderName, pos={5,Ypos+570}, size={390,20},title="New data folder:", proc=IR1D_setvarProc
	SetVariable NewDataFolderName value= root:packages:SASDataModification:NewDataFolderName,help={"Folder for the new data. Will be created, if does not exist. Use popup above to preselect."}
	SetVariable NewQwaveName, pos={5,Ypos+590}, size={320,20},title=" Q wave nm", proc=IR1D_setvarProc
	SetVariable NewQwaveName, value= root:packages:SASDataModification:NewQWaveName,help={"Input name for the new Q wave"}
	SetVariable NewIntensityWaveName, pos={5,Ypos+610}, size={320,20},title="Intensity nm", proc=IR1D_setvarProc
	SetVariable NewIntensityWaveName, value= root:packages:SASDataModification:NewIntensityWaveName,help={"Input name for the new intensity wave"}
	SetVariable NewErrorWaveName, pos={5,Ypos+630}, size={320,20},title="Error name", proc=IR1D_setvarProc
	SetVariable NewErrorWaveName, value= root:packages:SASDataModification:NewErrorWaveName,help={"Input name for the new Error wave"}

Ypos=670
	SetDrawEnv linethick= 3,linefgc= (52224,0,0)//red line
	DrawLine 16,YPos,339,Ypos
	Button Saveit,pos={Position,Ypos+10},size={80,20},proc=DWS_ButtonProc,title="Save qrs"	
	Button Plotq,pos={Position+100,Ypos+10},size={150,20},proc=DWS_ButtonProc,title="Plot saved"	
	

	DWS_SLDPopupControl("Morphology",3,"")//1 = rod 2 = sphere, 3=disk
	PopupMenu Morphology,mode=1,popvalue= "Disk"


END

Function DWS_SASPnlCkBox(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked	
	if (cmpstr("more",ctrlName)==0)
		wave composition=Root:packages:P:composition
		wave composition2=Root:packages:P:composition2
		if (!Checked)
			composition[12,100]=0
			composition2[12,100]=0
		else		
		endif		
	endif	
end


Function  DWS_IR1D_SaveData( ResultsInt,ResultsQ )
	Wave/Z ResultsInt 
	Wave/Z ResultsQ 
	
	string OldDf= GetDataFolder(1)
	SVAR NewDataFolderName=root:Packages:SASDataModification:NewDataFolderName
	SVAR NewIntensityWaveName=root:Packages:SASDataModification:NewIntensityWaveName
	SVAR NewQWavename=root:Packages:SASDataModification:NewQWavename
	SVAR NewErrorWaveName=root:Packages:SASDataModification:NewErrorWaveName

	if ((strlen(NewDataFolderName)<=1) || (strlen(NewIntensityWaveName)<=0)|| (strlen(NewQWaveName)<=0))
		Abort "Input output waves names"
	endif
	variable i
	string DataFldrNameStr

		if(WaveExists(ResultsInt)&&WaveExists(ResultsQ))
			if (numpnts(ResultsInt)!=numpnts(ResultsQ))
				DoAlert 1, "Intensity and Q waves DO NOT have same number of points. Do you want really to continue?"
				if (V_Flag==2)
					abort
				endif
			endif
		endif

	if(WaveExists(ResultsInt)&&WaveExists(ResultsQ))
		if (cmpstr(NewDataFolderName[strlen(NewDataFolderName)-1],":")!=0)
			NewDataFolderName+=":"
		endif
		setDataFolder root:
		For(i=0;i<ItemsInList(NewDataFolderName,":");i+=1)
			if (cmpstr(StringFromList(i, NewDataFolderName , ":"),"root")!=0)
				DataFldrNameStr = StringFromList(i, NewDataFolderName , ":")
				if(cmpstr(DataFldrNameStr[0],"'")==0)
					DataFldrNameStr = DataFldrNameStr[1,inf]
				endif
				if(cmpstr(DataFldrNameStr[strlen(DataFldrNameStr)-1],"'")==0)
					DataFldrNameStr = DataFldrNameStr[0,strlen(DataFldrNameStr)-2]
				endif
				NewDataFolder/O/S $(DataFldrNameStr)
			endif
		endfor	
	endif
	if(WaveExists(ResultsInt)&&WaveExists(ResultsQ))
		Wave/Z testOutputInt=$NewIntensityWaveName
		Wave/Z testOutputQ=$NewQWaveName
		if (WaveExists(testOutputInt) || WaveExists(testOutputQ))
			DoAlert 1, "Intensity and/or Q data with this name already exist, overwrite?"
			if (V_Flag!=1)
				abort 
			endif
		endif 
		Duplicate/O ResultsInt, $NewIntensityWaveName
		Duplicate/O ResultsQ, $NewQWaveName
	endif
	setDataFolder OldDf
end




Function DWS_SLDPopupControl(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr
	setdatafolder root:Packages:P
	if (cmpstr(ctrlName,"Radiation")==0)
		NVAR Type=Root:packages:P:Type
		type=popnum
	ENDIF
	if (cmpstr(ctrlName,"Pick1")==0)
		NVAR composition=Root:packages:P:Composition
	ENDIF
	
	if (cmpstr(ctrlName,"Morphology")==0)
		NVAR morphology=Root:packages:P:Morphology
		morphology=popNUM//1=ROD, 2= SPHERE,3 = DISK;4=Fractal rod;5=Fractal disk; 6 = Fractal sphere;7=tube; 8 = fractal tube	; 9 = hollow sphere
		If (morphology==9)//simplified hollow sphere
					SetVariable Thickness,disable=0, win=DWS_SLD_Panel
					SetVariable D,disable=1 ,win=DWS_SLD_Panel
					SetVariable persist,disable=1 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=1 ,win=DWS_SLD_Panel
					SetVariable length,disable=1 ,win=DWS_SLD_Panel
					SetVariable radius,disable=0 ,win=DWS_SLD_Panel
					//SetVariable Rinner,disable=0, win=DWS_SLD_Panel
		endif
		
		If (morphology==8)//fractal tube
					SetVariable Thickness,disable=0, win=DWS_SLD_Panel
					SetVariable D,disable=0 ,win=DWS_SLD_Panel
					SetVariable persist,disable=0 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=0 ,win=DWS_SLD_Panel
					SetVariable length,disable=1 ,win=DWS_SLD_Panel
					SetVariable radius,disable=0 ,win=DWS_SLD_Panel
					//SetVariable Rinner,disable=0, win=DWS_SLD_Panel
		endif
		
		If (morphology==7)//tube
					SetVariable Thickness,disable=0, win=DWS_SLD_Panel
					SetVariable D,disable=1 ,win=DWS_SLD_Panel
					SetVariable persist,disable=1 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=1 ,win=DWS_SLD_Panel
					SetVariable length,disable=0 ,win=DWS_SLD_Panel
					SetVariable radius,disable=0 ,win=DWS_SLD_Panel
					//SetVariable Rinner,disable=0, win=DWS_SLD_Panel
		endif
		If (morphology==1)//rod
					SetVariable Thickness,disable=1, win=DWS_SLD_Panel
					//SetVariable Rinner,disable=1, win=DWS_SLD_Panel
					SetVariable D,disable=1 ,win=DWS_SLD_Panel
					SetVariable persist,disable=1 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=1 ,win=DWS_SLD_Panel
					SetVariable length,disable=0 ,win=DWS_SLD_Panel
					SetVariable radius,disable=0 ,win=DWS_SLD_Panel
					
		endif
		if (morphology==2)//sphere 
			SetVariable Length,disable=1, win=DWS_SLD_Panel
			SetVariable Thickness,disable=1, win=DWS_SLD_Panel
			SetVariable D,disable=1 ,win=DWS_SLD_Panel
			SetVariable persist,disable=1 ,win=DWS_SLD_Panel
			SetVariable Rcluster,disable=1 ,win=DWS_SLD_Panel
			//SetVariable rinner, disable=1, win=DWS_SLD_Panel

		endif
		if (morphology==3)//Disk
			//SetVariable rinner, disable=1, win=DWS_SLD_Panel
			SetVariable Length,disable=1, win=DWS_SLD_Panel
			SetVariable Thickness,disable=0, win=DWS_SLD_Panel
			SetVariable D,disable=1 ,win=DWS_SLD_Panel
			SetVariable persist,disable=1 ,win=DWS_SLD_Panel
			SetVariable Rcluster,disable=1 ,win=DWS_SLD_Panel
			SetVariable radius,disable=0 ,win=DWS_SLD_Panel
			
		endif	
		if (morphology==4)//fractal rod
					SetVariable D,disable=0 ,win=DWS_SLD_Panel
					SetVariable persist,disable=0 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=0 ,win=DWS_SLD_Panel
					SetVariable length,disable=1 ,win=DWS_SLD_Panel
					SetVariable Thickness,disable=1, win=DWS_SLD_Panel
					SetVariable radius,disable=0 ,win=DWS_SLD_Panel
					//SetVariable rinner, disable=1, win=DWS_SLD_Panel

		endif	
		If(morphology==5)//fractal disk
					SetVariable Thickness,disable=0 ,win=DWS_SLD_Panel
					SetVariable length,disable=1 ,win=DWS_SLD_Panel
					SetVariable D,disable=0 ,win=DWS_SLD_Panel
					SetVariable persist,disable=0 ,win=DWS_SLD_Panel
					SetVariable Rcluster,disable=0 ,win=DWS_SLD_Panel
					SetVariable radius,disable=1 ,win=DWS_SLD_Panel
					//SetVariable rinner, disable=1, win=DWS_SLD_Panel

		endif
		If(morphology==6)//fractal sphere			
					SetVariable D,disable=0 ,win=DWS_SLD_Panel			
					SetVariable Rcluster,disable=0 ,win=DWS_SLD_Panel
					SetVariable length,disable=1 ,win=DWS_SLD_Panel
					SetVariable Thickness,disable=1 ,win=DWS_SLD_Panel
					SetVariable persist,disable=1 ,win=DWS_SLD_Panel
					//SetVariable rinner, disable=1, win=DWS_SLD_Panel

		 endif	
	ENDIF
end



Function DWS_InvPopupControl(ctrlName,popNum,popStr) : PopupMenuControl//for invariant calculation
	String ctrlName
	Variable popNum
	String popStr
	if (cmpstr(ctrlName,"invlevels")==0)//only one choice now
		setDataFolder root:Packages:SAS_Modeling	
		SVAR value=Root:packages:P:invlevels
		value=popStr
		NVAR Numberoflevels=root:Packages:Irena_UnifFit:NumberOfLevels//number used by panel
		variable originallevels=Numberoflevels
		variable invariant		
		//get the level 1 values
		NVAR Rg=$("root:Packages:irena_UnifFit:Level"+num2str(1)+"Rg")
		NVAR SASBackground//=root:Packages:SAS_Modeling:SASBackground
		NVAR Porod=$("root:Packages:irena_UnifFit:Level"+num2istr(1)+"P")
		NVAR B=$("root:Packages:irena_UnifFit:Level"+num2istr(1)+"B")	
		
		variable/g maxQ=2*pi/(Rg/10)
			variable tempPorod=Porod
			variable tempB=B
			variable minP=4
		If (Porod<=minP)//If porod is less than 4.  You must cut it off at some point
				SVAR DataFolderName
				SVAR Qwavename
				string origQwave=DataFolderName+ Qwavename
				wave orig= $origQwave
				variable n=numpnts($origQwave)
			//	maxq=orig[n]
				variable localmaxq=maxq
				prompt localmaxq, "Maximum Q"
				Doprompt "Enter Max q",localmaxq
				maxq=localmaxq
				tempPorod=4
				
		endif
		SVAR Wavesfolder=$("root:Packages:SAS_Modeling:DataFolderName")
		//IR1A_UpdatePorodSurface()  Stopped working with one of Jan's updates.  May be of no consequence
		SetDataFolder Wavesfolder
		variable Newnumpnts=2000, extrapnts=500
		Make/O/D/N=(Newnumpnts) root:Packages:SAS_Modeling:qUnifiedfitvector,qUnifiedfit,rUnifiedfit,rUnifiedfitq2,tempunifiedIntensity
		qUnifiedfit=(maxQ/(Newnumpnts-1))*p	
		rUnifiedfit=0
		//singlelevels
		if((cmpstr(popStr,"1")==0)||(cmpstr(popStr,"2")==0)||(cmpstr(popStr,"3")==0)||(cmpstr(popStr,"4")==0)||(cmpstr(popStr,"5")==0))
			variable level=str2Num(popStr)
			DWS_UnifiedCalcIntOne(qUnifiedfit,level,0)//RJ  zero is no cut off
			rUnifiedfit =tempunifiedIntensity
					variable temp
		else	
			strswitch(popStr)	//multiple levels.  All is whatever # used in original fit.
					case "1-2":	
					temp=2
						Break
					case "1-3":
						temp=3
						Break
					case "1-4":
						temp=4
						Break
					case "All":
						temp=originallevels
				endswitch		
			variable i,cuttoff
				for(i=1;i<=temp;i+=1)	// initialize variables;continue test
					cuttoff=(i!=1)//does not cut off level 1
					DWS_UnifiedCalcIntOne(qUnifiedfit,i,cuttoff)//qcutoff is zero for no cutoff
					rUnifiedfit=rUnifiedfit+tempunifiedIntensity
				endfor	
			
		endif
			//rUnifiedfit+=SASBackground	
			rUnifiedfit[0]=rUnifiedfit[1]	
			rUnifiedfitq2=rUnifiedfit*qUnifiedfit^2
			doupdate
				invariant=areaXY(qUnifiedfit, rUnifiedfitq2, 0, MaxQ)//invariant, need to add "Porod tail"//what about (1/2Pi^2)?
				tempB=rUnifiedfit[newnumpnts-1]*maxQ^4//makes -4 extension match last point of fit
			//Invariant+=abs((tempB*maxQ^(3-4))/(4-2))//extends with -4 exponent
			Invariant+=-tempB*maxQ^(3-abs(-4))/(3-abs(-4)) 
			NumberOfLevels=originalLevels
			SVAR basewave=root:Packages:SAS_Modeling:IntensityWaveName
			string rwavename="rq2"+basewave
			string uqwavename="qq2"+basewave
			wave qw=$uqwavename,rw=$rwavename
			duplicate/o qUnifiedfit qw//$uqwavename
			duplicate/o rUnifiedfitq2 rw//$rwavename
			Newnumpnts+=extrapnts
			redimension/n=(newnumpnts) qw, rw
			variable oldnumpnts=newnumpnts-extrapnts
			qw=(maxq*newnumpnts/(oldnumpnts-1)/Newnumpnts)*p
			make/o/n=(extrapnts) hiq
			hiq[0]=qw[oldnumpnts];hiq[extrapnts-1]=2//fixes hilimit on q
			logspacing(hiq)		
			qw[oldnumpnts,newnumpnts-1]=hiq[p-oldnumpnts]		
			rw[oldnumpnts,newnumpnts-1]=tempB/hiq[p-oldnumpnts]^2		
			TextBox/C/N=invar/F=0/A=MC "Invariant = "+num2str(invariant)+" cm-1A-3"
		RemoveFromGraph/z rUnifiedfit
		AppendToGraph/W=fitgraph rUnifiedfit vs qUnifiedfit
		ModifyGraph lsize=2,rgb(rUnifiedfit)=(0,0,65535)  
		
	 dowindow/R/k InvariantGraph
	Display/K=1/W=(270,375,570,750) rw vs qw as "q2 I(q) vs q"
	ModifyGraph grid=2,tick=2,mirror=1,fStyle=1,fSize=15,font="Times"
	Label left "\\F'arial'\\Z18I(q)(q \\S2\\M)"
	Label bottom "\\F'arial'\\Z18q (A\\S-1\\M)"
	ShowTools/A
	ShowInfo
	 ModifyGraph log=1
	dowindow/c InvariantGraph
	//AppendToGraph 
	killwaves hiq,TempUnifiedIntensity//,rUnifiedfitq2
	ENDIF
	
end


Function DWS_ButtonProc(ctrlName) : ButtonControl
	String ctrlName
	//string oldDf=GetDataFolder(1)
	NVAR morphology=Root:packages:P:Morphology
	wave composition=Root:packages:P:composition
	wave composition2=Root:packages:P:composition2
	NVAR SL=Root:packages:P:SL
	NVAR SL2=Root:packages:P:SL2
	NVAR SLD=Root:packages:P:SLD
	NVAR SLD2=Root:packages:P:SLD2
	NVAR Drhosq=Root:packages:P:Drhosq
	NVAR Drho=Root:packages:P:Drho
	NVAR radius=Root:packages:P:Radius
	NVAR thickness=Root:packages:P:thickness
	//NVAR rinner=Root:packages:P:rinner
	NVAR length=Root:packages:P:length
	NVAR persistencelength=Root:packages:P:persist
	NVAR D=Root:packages:P:D
	NVAR phi=Root:packages:P:Phi
	NVAR Rcluster=Root:packages:P:Rcluster
	NVAR SASBackground=root:Packages:SAS_Modeling:SASBackground:
	NVAR type=Root:packages:P:type//0=x, 1=neutron
	SVAR tagit=Root:packages:P:tagit
	variable chord

	string folder, cmd
			
	if(cmpstr(ctrlName,"Reset_SL")==0)
		Reset_SLs()
	endif
	if(cmpstr(ctrlName,"DisplaySLD")==0)
		Displayscattlength()
	endif
	
	if((cmpstr(ctrlName,"CalculateSLD")==0))//||(cmpstr(ctrlName,"CalculateUnified")==0))
		SL=ScattLength11(composition,type)//cm/g
		SL2= ScattLength11(composition2,type)
		If (numtype(SL2)==2)
			SL2 = 0
		endif
		SLD=SL*composition[0]//cm^-2
		SLD2= SL2*composition2[0]
		Drhosq=(SLD2-SLD)^2//cm-4
		Drho=(SLD2-SLD)*1e-16//A^-2
		
		NVAR phi=Root:packages:P:phi
		NVAR wtpct=Root:packages:P:wtpct
		NVAR samdensity=Root:packages:P:samdensity
		NVAR mixSLD=Root:packages:P:MixSLD
		wave composition=Root:packages:P:composition
		wave composition2=Root:packages:P:composition2
		variable matrixdens=composition2[0]
		variable skldens=composition[0]	
		phi = (wtpct/skldens)/((wtpct/skldens)+(100-wtpct)/matrixdens)
		samdensity=phi*skldens+(1-phi)*matrixdens
		MixSLD=1e-10*(phi*SLD+(1-phi)*SLD2)
		
	endif
	
	if( (cmpstr(ctrlName,"CalculateUnified")==0)||(cmpstr(ctrlName,"CalculateSLD")==0) )
		//dowindow IR1A_ControlPanel
		setDataFolder root:Packages:P
		//if (!DataFolderExists("root:Packages:SAS_Modeling"))		
		//	IR1A_UnifiedModel()
			//IR1A_Initialize()
			//Dowindow/K IR1A_controlPanel
		//endif
		make/o/n=200 qSASModel=p
		NVAR qmin=Root:packages:P:qmin
		NVAR qmax=Root:packages:P:qmax
		 qSASModel =10^(log(qmin)+p*((log(qmax)-log(qmin))/199))	
		 duplicate/o qSASmodel rSASmodel
		 variable G2,v
		    NVAR SASBackground=$("root:Packages:SAS_Modeling:SASBackground")
		    
		IF(Morphology==2)//sphere
			v=(4*pi/3)*(radius^3)//R in A
       		 G2=Drhosq*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1
			rsasmodel=G2*(IR1T_UniFiedsphereFF(qSASModel,radius,1,1,1,1,1))^2//radius must be hard radius
			variable B1=1.62*G2/Radius^4//cm-1 -4  Simple sphere
			variable Sv=3*phi/Radius//-1  hard radius
			Variable B=2*Pi*B1*Drhosq* phi*  Sv*1e16//real sphere  cm-4 -1
			print "B reaal sphere = "+num2str(B1)+"cm-1 -4"
			print "BsimpleSphere = "+num2str(B1)+"cm-1 -4"
			
		elseif (morphology==1)//rod
			 v=pi*(radius^2)*length//R in A//change because of normalization
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1
			 rSASModel=G2*(IR1T_UniFiedrodFF(qSASModel,radius,length,1,1,1,1))^2
			 
		elseif (morphology==4)//fractal rod
			 v=IR1T_FractalAggofRodsVol(Rcluster,Persistencelength,radius, D,1,1)//vol all primaries because or normalization to 1 at low q
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1	  		
			 rSASModel=G2*(gamma(D+1))*( IR1T_FractalAggofRodsFF( qSASModel,Rcluster, persistencelength,radius,D,0,0))^2//Jans fitting requires return of sqrt
		
		elseif (morphology==5) //fractal disk
			v=IR1T_FractalAggofDisksVol(Rcluster,thickness,Persistencelength,radius, D,1,1)//pi*(persistencelength^2)*thickness
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1	  
			 rSASModel=G2*(gamma(D+1))*(IR1T_FractalAggofDisksFF( qSASModel,thickness, persistencelength,Rcluster,D,0,0))^2//Jans fitting requires return of sqrt
		
		elseif (morphology ==6)//fractal sphere
			v=IR1T_FractalAggofSpheresVol(Rcluster,radius,D,0,0,0)//R in A
       		G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
			 G2=G2*(1e-8)^3//cm-1	 
		    	rSASModel=G2*(gamma(D+1))*( IR1T_FractalAggofSpheresFF(qSASModel,Rcluster,radius,D,0,0,0))^2
		
		elseif (morphology==7)//tube
			 variable rinner=radius-thickness
			 v=pi*(radius^2-rinner^2)*length//R in A
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1
			 rSASModel=G2*(IR1T_UniFiedtubeFF(qSASModel, radius,length,thickness,1,1,1))^2
			 
		elseif (morphology==8)//fractal tube//added by RSJ 6July2006
			 rinner=radius-thickness
			 v=IR1T_FractalAggofTubesVol(Rcluster, persistencelength,radius,D,thickness,1)//pi*(radius^2-rinner^2)*persistencelength//R in A
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1	  		
			 rSASModel=G2*(gamma(D+1))*(IR1T_FractalAggofTubesFF( qSASModel,Rcluster, persistencelength,radius,D,thickness,0))^2//Jans fitting requires return of sqrt
			 
		elseif (morphology ==9)//*Hollow Sphere****************************	NOT DONE
			 v=IR1T_UnifiedHollowSphereVolume(radius, Thickness,1,1,1,1)
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1
			 rSASModel=G2*(IR1T_UnifiedHollowSphereFF(qSASModel,radius,thickness,1,1,1,1))^2
			 
		else//disk					
			v=IR1T_UnifiedDiscVolume(radius, thickness,0,0,0,0)
       		 G2=(Drhosq)*v*phi*(1-phi)//cm-4  A3
       		 G2=G2*(1e-8)^3//cm-1
			 rSASModel=G2*(IR1T_UniFiedDiskFF(qSASModel,radius,thickness,0,0,0,0))^2
		endif
		   rSASModel+=SASBackground	
		   string traces= TraceNameList("",";",1)
		  
	 if (stringmatch(traces,"*rSASmodel*")==1)	  
		 		   	
		   	if(morphology==7)//tube
		     		tagit="Simplified Tube\rradius = "+num2str(radius)+" "+"\rlength = "+num2str(length)+" "+"\rwall thickness = "+num2str(thickness)+""//+"\rrinner = "+num2str(rinner)+"" 
		     		chord =2*thickness
		     		tagit+="\rmean chord = "+num2str(chord)
		     
		     	elseif(morphology==8)//fractal tube
				tagit="Fractal Tube\rradius = "+num2str(radius)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)+"\rwall thickness = "+num2str(thickness)+""
		     	
		   		elseif(morphology==4)//fractal rod
				tagit="Fractal Rod\rradius = "+num2str(radius)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
		     
		    		 elseif (morphology==5)//fractal disk
				tagit="Fractal Disk\rthickness = "+num2str(thickness)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
		     
		     	elseif(morphology==1)//rod
		     		tagit="Simplified Rod\rradius = "+num2str(radius)+"\rlength = "+num2str(length)+" "
		     		chord =2*radius
		     		tagit+="\rmean chord = "+num2str(chord)
		     
		    		 elseif(morphology==3)//disk
		     		tagit="Simplified Disk\rradius = "+num2str(radius)+"\rthickness = "+num2str(thickness)+" "
		    
		    		elseif (morphology ==6)//fractal sphere
		     		tagit="Fractal Sphere\rradius = "+num2str(radius)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
		     	else//sphere
		     		tagit="Simplified Sphere\rradius = "+num2str(radius)+" "
		     endif   
		  	
		  	Tag/C/N=SASmodeltag/L=1 rSASmodel, 50,tagit
		
		endif
	endif
	
	


	
	if(cmpstr(ctrlName,"saveit")==0)//*******
		Wave/Z rSASModel =Root:packages:P:rSASModel
		Wave/Z qSASModel =Root:packages:P:qSASModel
		string info="1=rod,2=sphere,3=disk,4=wromlike rod, 5=flxible disk, 6=fractal sphere\rradius="+num2str(radius)+";thickness="+num2str(thickness)+";"
		info=info+"length="+num2str(length)+";phi="+num2str(phi)+";"
		info=info+"SLD="+num2str(SLD)+";SLD2="+num2str(SLD2)+";Morphology="+num2str(morphology)+";"
		info=info+"SASBackground="+num2str(SASBackground)+";Radiation="+num2str(type)+";"
		info=info+"D="+num2str(D)+";Persistence length="+num2str(persistencelength)+";"
		Note/k rSASModel;Note rSASModel, info
		 DWS_IR1D_SaveData(rSASmodel,qSASmodel)
	endif
	
	
	if((cmpstr(ctrlName,"Plot")==0)||(cmpstr(ctrlName,"Plotq")==0))//plot on top graph	
		setDataFolder root:Packages:SASDataModification
		//wave swave=root:packages:SASDataModification:ResultsE
		wave qwave=Root:packages:P:qSASModel
		wave rwave=Root:packages:P:rSASModel
		if(!cmpstr(ctrlName,"Plot")==0)	
			SVAR NewDataFolderName=root:Packages:SASDataModification:NewDataFolderName
			SVAR NewIntensityWaveName=root:Packages:SASDataModification:NewIntensityWaveName
			SVAR NewQWavename=root:Packages:SASDataModification:NewQWavename
			//SVAR NewErrorWaveName=root:Packages:SASDataModification:NewErrorWaveName
			setdatafolder NewDataFolderName
			wave rwave =$NewIntensityWaveName
			wave qwave = $NewQWavename	
		endif
		
//**********************Removed this tag to eliminate duplication of the tags//RSJ 6July06
		if(cmpstr(WinList("*",";","WIN:1"), "" )==0)
		 	display/n=loglogplot/K=1/W=(400,0,700,350 ) rwave vs qwave
		 	ModifyGraph log=1;DelayUpdate
			Label left "\\Z16Intensity (cm\\S-1\\M\\Z16)";DelayUpdate
			Label bottom "\\Z16q(A\S-1\M\Z16)"
			Legend/C/N=legend1/A=MC
			ModifyGraph margin(bottom)=50
			string Newintensitywavedname="rwave"
		 else
			AppendToGraph rwave vs qwave
			string name=nameofwave(rwave)
			ModifyGraph lsize($name)=2;DelayUpdate
			ModifyGraph rgb($name)=(4369,4369,4369)
			string Tagname="tagrsasmodel"//+newIntensitywavename[0,30]
			
			SVAR tagit=Root:packages:P:tagit
			if (morphology==4)//fractal rod
				tagit="fractal rod\rradius = "+num2str(radius)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
		     	 
		     	 elseif(morphology==8)//fractal tube
				tagit="radius = "+num2str(radius)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)+"\rwall thickness = "+num2str(thickness)+""
		     	
		     	elseif (morphology==5)//fractal disk
				tagit="thickness = "+num2str(thickness)+" \rpersistence length = "+num2str(persistencelength)+" \rRcluster = "+num2str(Rcluster)+" \rD = "+num2str(D)
		     	
		     	elseif(morphology==1)//rod
		     		tagit="rod\rradius = "+num2str(radius)+"\rlength = "+num2str(length)+" "
		     		chord =2*radius
		     		tagit+="\rmean chord = "+num2str(chord)
		     	
		     	elseif(morphology==3)//disk
		     		tagit="disk\rradius = "+num2str(radius)+"\rthickness = "+num2str(thickness)+" "
		     	
		     	elseif(morphology==7)//tube
		     		tagit="tube\rradius = "+num2str(radius)+" "+"\rlength = "+num2str(length)+" "+"\rshell thickness = "+num2str(thickness)+""//+"\rrinner = "+num2str(rinner)+"" 
		     			chord =2*thickness
		     		tagit+="\rmean chord = "+num2str(chord)
		     	
		     	else//sphere
		     		tagit="radius = "+num2str(radius)+" "
		     	endif
	
		 //    	cmd= 	"Tag/C/N="+Tagname+"/L=1 "+ name+", 50,$tagit"
		  // 	execute cmd
		     	//Tag/C/N=tagname/L=1 $name, 50,tagit
		     
		endif
			
	endif
	
	if(cmpstr(ctrlName,"smear")==0)
		SVAR datafolder=root:Packages:SAS_Modeling:DataFolderName
		setdatafolder datafolder
		wave rdsm=root:Packages:SAS_Modeling:TempUnifiedIntensity
		wave qdsm=root:Packages:SAS_Modeling:OriginalQvector
		duplicate/o rdsm,runified_smr
		
		cmd="IR1B_SmearData(root:Packages:SAS_Modeling:TempUnifiedIntensity,root:Packages:SAS_Modeling:OriginalQvector,.037,rUnified_smr)"
		print cmd
		execute cmd
		//IR1B_SmearData(Int_to_smear, Q_vec_sm, slitLength, Smeared_int)	
	endif

End	
